package org.danbrough.hb

import io.ktor.server.engine.ApplicationEngine
import io.ktor.server.engine.EmbeddedServer
import io.ktor.server.netty.Netty
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import org.danbrough.hb.server.KtorApplicationEngineFactory
import kotlin.concurrent.thread


abstract class BaseAndroidJVMContext(scope: CoroutineScope) :
  HBContext(scope) {

  init {
    Runtime.getRuntime().addShutdownHook(thread(start = false) {
      log.debug { "${this@BaseAndroidJVMContext::class} shutdown hook" }
      running = false
    })
  }

  override fun getEnv(name: String): String? = System.getenv(name)

  override fun threadName(): String = Thread.currentThread().name

  @Suppress("UNCHECKED_CAST")
  override val serverEngine: KtorApplicationEngineFactory =
    Netty as KtorApplicationEngineFactory

  override val ioDispatcher: CoroutineDispatcher
    get() = Dispatchers.IO


}
