package org.danbrough.hb

import android.content.Context
import androidx.core.net.toUri
import app.cash.sqldelight.driver.android.AndroidSqliteDriver
import io.ktor.client.HttpClient
import io.ktor.client.HttpClientConfig
import io.ktor.client.engine.android.Android
import io.ktor.server.engine.ApplicationEngine
import kotlinx.coroutines.CoroutineScope
import kotlinx.io.Sink
import kotlinx.io.Source
import kotlinx.io.asSink
import kotlinx.io.asSource
import kotlinx.io.buffered

private class AndroidHBContext(scope: CoroutineScope, val context: Context) :
  BaseAndroidJVMContext(scope) {

  companion object {
    const val DB_NAME = "hb.db"

  }


  override fun internalCreateHttpClient(block: HttpClientConfig<*>.() -> Unit): HttpClient =
    HttpClient(Android, block)


  override val hbDbProvider: SqlDriverProvider = {
    AndroidSqliteDriver(Habitrack.Schema, context, DB_NAME)
  }


  override fun configureServer(configuration: ApplicationEngine.Configuration) {
  }


  /*TODO: Fix this   override val nodeID: String by lazy {
      val applicationContext = context.applicationContext
      val prefID = "${applicationContext.packageName}.NODE_ID"
      val prefs = applicationContext.getSharedPreferences("config", MODE_PRIVATE)
      lateinit var nodeID: String
      if (!prefs.contains(prefID)) {
        nodeID = UuidUtils.generateUUIDv7().toHexDashString()
        log.warn { "initializing $prefID with $nodeID" }
        prefs.edit { putString(prefID, nodeID) }
      } else nodeID = prefs.getString(prefID, null)!!
      log.info { "nodeID: $nodeID" }
      nodeID
    }*/

  override fun pathToSource(path: String): Source =
    context.contentResolver.openInputStream(path.toUri())!!.asSource().buffered()

  override fun pathToSink(path: String): Sink =
    context.contentResolver.openOutputStream(path.toUri())!!.asSink().buffered()

}


