package org.danbrough.hb

import com.github.ajalt.clikt.parameters.options.default
import com.github.ajalt.clikt.parameters.options.option
import com.github.ajalt.clikt.parameters.types.int
import kotlinx.coroutines.delay
import org.danbrough.hb.commands.commands
import org.danbrough.hb.commands.configCommand
import org.danbrough.hb.server.serverCommand
import org.danbrough.krch.CommandMap
import org.danbrough.krch.KrchContext
import kotlin.time.Duration.Companion.seconds

fun HBContext.countCommand(name: String) = object : KrchContext.Command(name) {
  val message by option().default("default message")
  val count by option().int().default(2)
  override fun run() {
    runInBackground {
      log.debug { "countCommand($name)::run() message:<$message> count: $count" }
      for (n in 1..count) {
        log.info { "countCommand($name)::run() message:<$message> n: $n" }
        delay(1.seconds)
      }
    }
    log.debug { "countCommand($name) finished" }
  }
}

val HBContext.commandMap: CommandMap
  get() = CommandMap(
    "count" to ::countCommand, "server" to ::serverCommand, "config" to ::configCommand
  ).commands(this)