package org.danbrough.hb.commands

import org.danbrough.hb.HBContext
import org.danbrough.krch.CommandMap


fun CommandMap.commands(context: HBContext): CommandMap = context.run {
  peerCommands(this)
}

private fun CommandMap.peerCommands(context: HBContext): CommandMap = context.run {
  addAll(
    "peerList" to ::peerListCommand,
    "peerAdd" to ::peerAddCommand,
    "peerDelete" to ::peerDeleteCommand,
    "peerUpdate" to ::peerUpdateCommand,
    "waitForAll" to ::waitCommand,
  )
}