package org.danbrough.hb.commands

import io.ktor.client.plugins.websocket.DefaultClientWebSocketSession
import io.ktor.client.plugins.websocket.ws
import io.ktor.client.request.HttpRequestBuilder
import org.danbrough.hb.HBContext
import org.danbrough.hb.Peer
import org.danbrough.hb.log

suspend fun clientSession(
  context: HBContext,
  peer: Peer,
  request: HttpRequestBuilder.() -> Unit = {},
  block: suspend DefaultClientWebSocketSession.() -> Unit
) {
  log.info { "clientSession() " }

  val serverURL = peer.wsUrl
  log.info { "connecting to $serverURL" }
  context.createHttpClient().ws(serverURL, request) {
    block()
  }
}