package org.danbrough.hb

import kotlinx.datetime.LocalDateTime
import kotlinx.datetime.TimeZone
import kotlinx.datetime.toInstant
import kotlinx.datetime.toLocalDateTime
import kotlin.time.Clock

object Utils {
  val today: Long
    get() = Clock.System.now().toLocalDateTime(TimeZone.currentSystemDefault()).let {
      LocalDateTime(
        it.year,
        it.month,
        it.day,
        0,
        0,
        0,
        0
      ).toInstant(TimeZone.currentSystemDefault()).toEpochMilliseconds()
    }

  fun now(): Long = Clock.System.now().toEpochMilliseconds()
}