package org.danbrough.hb

import app.cash.sqldelight.driver.jdbc.sqlite.JdbcSqliteDriver
import io.ktor.client.HttpClient
import io.ktor.client.HttpClientConfig
import io.ktor.server.engine.ApplicationEngine
import io.ktor.server.netty.NettyApplicationEngine
import kotlinx.coroutines.CoroutineScope


class HBContextJVM(scope: CoroutineScope) : BaseAndroidJVMContext(scope) {


  override fun internalCreateHttpClient(block: HttpClientConfig<*>.() -> Unit) = HttpClient(block)

  override val hbDbProvider: SqlDriverProvider = {
    //val dbPath = File(System.getenv("HOME"), ".habitrack/hb2.db").absolutePath
    log.info { "opening database at ${rootCommand.dbPath}" }
    JdbcSqliteDriver("jdbc:sqlite:${rootCommand.dbPath}", schema = Habitrack.Schema)
  }

  /**
   * This is a comment
   */

  /*override val spaceXDbProvider: SqlDriverProvider = {
    val dbPath = File("/tmp/spacex.db").absolutePath
    JdbcSqliteDriver("jdbc:sqlite:$dbPath", schema = AppDatabase.Schema)
  }
*/
  override fun configureServer(configuration: ApplicationEngine.Configuration) {
    (configuration as NettyApplicationEngine.Configuration).apply {
      this.shutdownTimeout = 2000
    }
  }
}


