package org.danbrough.hb

import kotlinx.serialization.Serializable
import kotlin.uuid.Uuid

@Serializable
data class JsonLog(
  val id: String,
  val subject: String,
  val count: Int,
  val node: String?
) {
  /*  val time: Instant
      get() = Uuid.parse(id).time*/
}

val Log.jsonLog: JsonLog
  get() = JsonLog(
    Uuid.fromLongs(index1, index2).toHexDashString(),
    subject = subject,
    count = count.toInt(),
    node = node
  )


val JsonLog.log: Log
  get() = Uuid.parse(id).toLongs { msb, lsb ->
    Log(0, msb, lsb, subject, count.toLong(), node)
  }

