package org.danbrough.hb

import app.cash.sqldelight.ColumnAdapter
import kotlin.Long
import kotlin.String
import org.danbrough.hb.commands.PeerFlags

public data class Peer(
  public val id: Long,
  public val name: String,
  public val url: String,
  public val remoteID: Long,
  public val localID: Long,
  public val flags: PeerFlags,
  public val password: String?,
) {
  public class Adapter(
    public val flagsAdapter: ColumnAdapter<PeerFlags, Long>,
  )
}
