package org.danbrough.hb

import app.cash.sqldelight.Query
import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlCursor
import app.cash.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Long
import kotlin.String
import org.danbrough.hb.commands.PeerFlags

public class HBQueries(
  driver: SqlDriver,
  private val PeerAdapter: Peer.Adapter,
) : TransacterImpl(driver) {
  public fun <T : Any> logEntries(mapper: (
    id: Long,
    index1: Long,
    index2: Long,
    subject: String,
    count: Long,
    node: String?,
  ) -> T): Query<T> = Query(314_054_596, arrayOf("Log"), driver, "HB.sq", "logEntries", "SELECT Log.id, Log.index1, Log.index2, Log.subject, Log.count, Log.node FROM Log ORDER BY id ASC") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getLong(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)!!,
      cursor.getString(5)
    )
  }

  public fun logEntries(): Query<Log> = logEntries(::Log)

  public fun <T : Any> logLatest(mapper: (
    id: Long,
    index1: Long,
    index2: Long,
    subject: String,
    count: Long,
    node: String?,
  ) -> T): Query<T> = Query(1_583_990_227, arrayOf("Log"), driver, "HB.sq", "logLatest", "SELECT Log.id, Log.index1, Log.index2, Log.subject, Log.count, Log.node FROM Log ORDER BY id DESC LIMIT 1") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getLong(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)!!,
      cursor.getString(5)
    )
  }

  public fun logLatest(): Query<Log> = logLatest(::Log)

  public fun <T : Any> logLatestByNode(node: String?, mapper: (
    id: Long,
    index1: Long,
    index2: Long,
    subject: String,
    count: Long,
    node: String?,
  ) -> T): Query<T> = LogLatestByNodeQuery(node) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getLong(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)!!,
      cursor.getString(5)
    )
  }

  public fun logLatestByNode(node: String?): Query<Log> = logLatestByNode(node, ::Log)

  public fun <T : Any> logEntriesDesc(mapper: (
    id: Long,
    index1: Long,
    index2: Long,
    subject: String,
    count: Long,
    node: String?,
  ) -> T): Query<T> = Query(1_170_147_445, arrayOf("Log"), driver, "HB.sq", "logEntriesDesc", "SELECT Log.id, Log.index1, Log.index2, Log.subject, Log.count, Log.node FROM Log ORDER BY id DESC") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getLong(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)!!,
      cursor.getString(5)
    )
  }

  public fun logEntriesDesc(): Query<Log> = logEntriesDesc(::Log)

  public fun <T : Any> logEntriesByNode(node: String?, mapper: (
    id: Long,
    index1: Long,
    index2: Long,
    subject: String,
    count: Long,
    node: String?,
  ) -> T): Query<T> = LogEntriesByNodeQuery(node) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getLong(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)!!,
      cursor.getString(5)
    )
  }

  public fun logEntriesByNode(node: String?): Query<Log> = logEntriesByNode(node, ::Log)

  public fun <T : Any> logEntriesByIndex1(index1: Long, mapper: (
    id: Long,
    index1: Long,
    index2: Long,
    subject: String,
    count: Long,
    node: String?,
  ) -> T): Query<T> = LogEntriesByIndex1Query(index1) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getLong(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)!!,
      cursor.getString(5)
    )
  }

  public fun logEntriesByIndex1(index1: Long): Query<Log> = logEntriesByIndex1(index1, ::Log)

  public fun <T : Any> logEntriesById(id: Long, mapper: (
    id: Long,
    index1: Long,
    index2: Long,
    subject: String,
    count: Long,
    node: String?,
  ) -> T): Query<T> = LogEntriesByIdQuery(id) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getLong(2)!!,
      cursor.getString(3)!!,
      cursor.getLong(4)!!,
      cursor.getString(5)
    )
  }

  public fun logEntriesById(id: Long): Query<Log> = logEntriesById(id, ::Log)

  public fun <T : Any> logMaxId(mapper: (MAX: Long?) -> T): Query<T> = Query(1_991_685_587, arrayOf("Log"), driver, "HB.sq", "logMaxId", "SELECT MAX(id) FROM Log") { cursor ->
    mapper(
      cursor.getLong(0)
    )
  }

  public fun logMaxId(): Query<LogMaxId> = logMaxId(::LogMaxId)

  public fun logGetIDFromIndex1(index1: Long): Query<Long> = LogGetIDFromIndex1Query(index1) { cursor ->
    cursor.getLong(0)!!
  }

  public fun <T : Any> dbMetadata(mapper: (id: Long, version: Long) -> T): Query<T> = Query(33_988_837, arrayOf("DBMetadata"), driver, "HB.sq", "dbMetadata", "SELECT DBMetadata.id, DBMetadata.version FROM DBMetadata") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!
    )
  }

  public fun dbMetadata(): Query<DBMetadata> = dbMetadata(::DBMetadata)

  public fun <T : Any> peers(mapper: (
    id: Long,
    name: String,
    url: String,
    remoteID: Long,
    localID: Long,
    flags: PeerFlags,
    password: String?,
  ) -> T): Query<T> = Query(-1_089_201_863, arrayOf("Peer"), driver, "HB.sq", "peers", "SELECT Peer.id, Peer.name, Peer.url, Peer.remoteID, Peer.localID, Peer.flags, Peer.password FROM Peer") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getLong(3)!!,
      cursor.getLong(4)!!,
      PeerAdapter.flagsAdapter.decode(cursor.getLong(5)!!),
      cursor.getString(6)
    )
  }

  public fun peers(): Query<Peer> = peers(::Peer)

  public fun <T : Any> peerGetByName(name: String, mapper: (
    id: Long,
    name: String,
    url: String,
    remoteID: Long,
    localID: Long,
    flags: PeerFlags,
    password: String?,
  ) -> T): Query<T> = PeerGetByNameQuery(name) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!,
      cursor.getLong(3)!!,
      cursor.getLong(4)!!,
      PeerAdapter.flagsAdapter.decode(cursor.getLong(5)!!),
      cursor.getString(6)
    )
  }

  public fun peerGetByName(name: String): Query<Peer> = peerGetByName(name, ::Peer)

  /**
   * @return The number of rows updated.
   */
  public fun insert(
    index1: Long,
    index2: Long,
    subject: String,
    count: Long,
    node: String?,
  ): QueryResult<Long> {
    val result = driver.execute(402_792_913, """
        |INSERT INTO Log(index1,index2,subject,count,node)
        |    VALUES (?,?, ?,?,?)
        """.trimMargin(), 5) {
          var parameterIndex = 0
          bindLong(parameterIndex++, index1)
          bindLong(parameterIndex++, index2)
          bindString(parameterIndex++, subject)
          bindLong(parameterIndex++, count)
          bindString(parameterIndex++, node)
        }
    notifyQueries(402_792_913) { emit ->
      emit("Log")
    }
    return result
  }

  /**
   * @return The number of rows updated.
   */
  public fun insertOrReplace(Log: Log): QueryResult<Long> {
    val result = driver.execute(1_503_780_992, """INSERT OR REPLACE INTO Log (id, index1, index2, subject, count, node) VALUES (?, ?, ?, ?, ?, ?)""", 6) {
          var parameterIndex = 0
          bindLong(parameterIndex++, Log.id)
          bindLong(parameterIndex++, Log.index1)
          bindLong(parameterIndex++, Log.index2)
          bindString(parameterIndex++, Log.subject)
          bindLong(parameterIndex++, Log.count)
          bindString(parameterIndex++, Log.node)
        }
    notifyQueries(1_503_780_992) { emit ->
      emit("Log")
    }
    return result
  }

  /**
   * @return The number of rows updated.
   */
  public fun logDeleteAll(): QueryResult<Long> {
    val result = driver.execute(1_293_659_690, """DELETE FROM Log""", 0)
    notifyQueries(1_293_659_690) { emit ->
      emit("Log")
    }
    return result
  }

  /**
   * @return The number of rows updated.
   */
  public fun updateMetadata(DBMetadata: DBMetadata): QueryResult<Long> {
    val result = driver.execute(-1_573_386_704, """INSERT OR REPLACE INTO DBMetadata (id, version) VALUES (?, ?)""", 2) {
          var parameterIndex = 0
          bindLong(parameterIndex++, DBMetadata.id)
          bindLong(parameterIndex++, DBMetadata.version)
        }
    notifyQueries(-1_573_386_704) { emit ->
      emit("DBMetadata")
    }
    return result
  }

  /**
   * @return The number of rows updated.
   */
  public fun peerDelete(name: String): QueryResult<Long> {
    val result = driver.execute(1_298_523_333, """DELETE FROM Peer WHERE name = ?""", 1) {
          var parameterIndex = 0
          bindString(parameterIndex++, name)
        }
    notifyQueries(1_298_523_333) { emit ->
      emit("Peer")
    }
    return result
  }

  /**
   * @return The number of rows updated.
   */
  public fun peerAdd(
    name: String,
    url: String,
    remoteID: Long,
    localID: Long,
    flags: PeerFlags,
    password: String?,
  ): QueryResult<Long> {
    val result = driver.execute(1_248_985_031, """INSERT INTO Peer(name,url,remoteID,localID,flags,password) VALUES (?,?,?,?,?,?)""", 6) {
          var parameterIndex = 0
          bindString(parameterIndex++, name)
          bindString(parameterIndex++, url)
          bindLong(parameterIndex++, remoteID)
          bindLong(parameterIndex++, localID)
          bindLong(parameterIndex++, PeerAdapter.flagsAdapter.encode(flags))
          bindString(parameterIndex++, password)
        }
    notifyQueries(1_248_985_031) { emit ->
      emit("Peer")
    }
    return result
  }

  /**
   * @return The number of rows updated.
   */
  public fun peerUpdate(Peer: Peer): QueryResult<Long> {
    val result = driver.execute(1_795_135_459, """INSERT OR REPLACE INTO Peer (id, name, url, remoteID, localID, flags, password) VALUES (?, ?, ?, ?, ?, ?, ?)""", 7) {
          var parameterIndex = 0
          bindLong(parameterIndex++, Peer.id)
          bindString(parameterIndex++, Peer.name)
          bindString(parameterIndex++, Peer.url)
          bindLong(parameterIndex++, Peer.remoteID)
          bindLong(parameterIndex++, Peer.localID)
          bindLong(parameterIndex++, PeerAdapter.flagsAdapter.encode(Peer.flags))
          bindString(parameterIndex++, Peer.password)
        }
    notifyQueries(1_795_135_459) { emit ->
      emit("Peer")
    }
    return result
  }

  private inner class LogLatestByNodeQuery<out T : Any>(
    public val node: String?,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("Log", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("Log", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> = driver.executeQuery(null, """SELECT Log.id, Log.index1, Log.index2, Log.subject, Log.count, Log.node FROM Log WHERE node ${ if (node == null) "IS" else "=" } ? ORDER BY id DESC LIMIT 1""", mapper, 1) {
      var parameterIndex = 0
      bindString(parameterIndex++, node)
    }

    override fun toString(): String = "HB.sq:logLatestByNode"
  }

  private inner class LogEntriesByNodeQuery<out T : Any>(
    public val node: String?,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("Log", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("Log", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> = driver.executeQuery(null, """SELECT Log.id, Log.index1, Log.index2, Log.subject, Log.count, Log.node FROM Log WHERE node ${ if (node == null) "IS" else "=" } ?""", mapper, 1) {
      var parameterIndex = 0
      bindString(parameterIndex++, node)
    }

    override fun toString(): String = "HB.sq:logEntriesByNode"
  }

  private inner class LogEntriesByIndex1Query<out T : Any>(
    public val index1: Long,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("Log", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("Log", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> = driver.executeQuery(-792_427_334, """SELECT Log.id, Log.index1, Log.index2, Log.subject, Log.count, Log.node FROM Log WHERE index1 > ?""", mapper, 1) {
      var parameterIndex = 0
      bindLong(parameterIndex++, index1)
    }

    override fun toString(): String = "HB.sq:logEntriesByIndex1"
  }

  private inner class LogEntriesByIdQuery<out T : Any>(
    public val id: Long,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("Log", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("Log", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> = driver.executeQuery(1_170_105_782, """SELECT Log.id, Log.index1, Log.index2, Log.subject, Log.count, Log.node FROM Log WHERE id > ?""", mapper, 1) {
      var parameterIndex = 0
      bindLong(parameterIndex++, id)
    }

    override fun toString(): String = "HB.sq:logEntriesById"
  }

  private inner class LogGetIDFromIndex1Query<out T : Any>(
    public val index1: Long,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("Log", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("Log", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> = driver.executeQuery(1_909_385_966, """SELECT id FROM Log WHERE index1 > ? ORDER BY id LIMIT 1""", mapper, 1) {
      var parameterIndex = 0
      bindLong(parameterIndex++, index1)
    }

    override fun toString(): String = "HB.sq:logGetIDFromIndex1"
  }

  private inner class PeerGetByNameQuery<out T : Any>(
    public val name: String,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("Peer", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("Peer", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> = driver.executeQuery(217_853_214, """SELECT Peer.id, Peer.name, Peer.url, Peer.remoteID, Peer.localID, Peer.flags, Peer.password FROM Peer WHERE name = ?""", mapper, 1) {
      var parameterIndex = 0
      bindString(parameterIndex++, name)
    }

    override fun toString(): String = "HB.sq:peerGetByName"
  }
}
