package org.danbrough.hb.commands

import com.github.ajalt.clikt.parameters.options.option
import com.github.ajalt.clikt.parameters.options.required
import io.ktor.client.plugins.websocket.receiveDeserialized
import io.ktor.client.plugins.websocket.ws
import io.ktor.client.request.parameter
import kotlinx.coroutines.isActive
import org.danbrough.hb.HBContext
import org.danbrough.hb.log
import org.danbrough.hb.server.Message
import org.danbrough.krch.KrchContext

fun HBContext.watchDataCommand(name: String) = object : KrchContext.Command(name) {
  val peerName by option("--peer").required()

  override fun run() {
    log.info { "${this::class.simpleName}::run() peer:$peerName" }
    val db = hbDatabase
    val peer = db.peerGetByName(peerName).executeAsOneOrNull()
    peer ?: error("Peer $peerName not found")
    log.trace { "found peer: ${peer.asString()}" }
    if (!peer.flags.enabled) error("Peer $peerName is not enabled")
    val serverURL = "${peer.url.replace("http", "ws")}/watch"
    log.info { "connecting to $serverURL" }

    runInForeground {
      runCatching {
        createHttpClient().ws(serverURL, request = {
          parameter("fromID", peer.localID)
        }) {
          while (isActive) {
            log.trace { "reading message .." }
            val message = receiveDeserialized<Message>()
            log.trace { "received: $message" }
          }
        }
      }.exceptionOrNull().also {
        log.info { "session finished because:${it?.message}" }
      }
    }

  }
}