package org.danbrough.hb.commands

import com.github.ajalt.clikt.parameters.options.option
import com.github.ajalt.clikt.parameters.options.required
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.json.io.encodeToSink
import org.danbrough.hb.HBContext
import org.danbrough.hb.jsonLog
import org.danbrough.hb.log
import org.danbrough.krch.KrchContext

@OptIn(ExperimentalSerializationApi::class)
fun HBContext.saveToFile(path: String) {
  log.info { "saveToFile(): $path" }
  pathToSink(path).use { sink ->
    hbDatabase.logEntries().executeAsList().forEach { entry ->
      json.encodeToSink(entry.jsonLog, sink)
    }
  }
}

fun HBContext.exportCommand(name: String) = object : KrchContext.Command(name) {
  val file: String by option().required()

  @OptIn(ExperimentalSerializationApi::class)
  override fun run() {
    saveToFile(file)
  }
}

