package org.danbrough.hb.server

import io.ktor.server.auth.AuthenticationConfig
import io.ktor.server.auth.bearer
import org.danbrough.hb.log

fun AuthenticationConfig.configureAuthentication(adminPassword: String) {
  log.debug { "${this::class}::configureAuthentication" }
  bearer("admin") {
    realm = "Admin"
    authenticate { credential ->
      log.debug { "authenticating admin request: $this credential: $credential token:${credential.token}" }
      if (credential.token == adminPassword) CustomPrincipal("admin", realm!!)
      else null
    }
  }

  bearer("habitrack") {
    realm = "Habitrack"
    authenticate { credential ->
      if (credential.token == "habitrack") {
        //log.trace { "auth ok" }
        CustomPrincipal("Dan", realm!!)
      } else let {
        log.error { "invalid credential: ${credential.token}" }
        null
      }
    }
  }
}



