package org.danbrough.hb.server

import io.ktor.server.routing.Routing
import io.ktor.server.websocket.receiveDeserialized
import io.ktor.server.websocket.webSocket
import io.ktor.websocket.CloseReason
import io.ktor.websocket.close
import kotlinx.coroutines.isActive
import org.danbrough.hb.HBContext
import org.danbrough.hb.commands.serverSyncHandler
import org.danbrough.hb.log


fun Routing.webSocketHandler(context: HBContext, path: String) =
  webSocket(path) {

    val db = context.hbDatabase

    log.debug { "webSocket session started" }

    runCatching {
      while (isActive) {
        val message = receiveDeserialized<Message>()
        log.info { "received: $message" }
        when (message) {
          is Message.Sync -> serverSyncHandler(message)
          else -> {
            log.error { "unhandled message: $message" }
            close(CloseReason(CloseReason.Codes.PROTOCOL_ERROR, "Unexpected message: $message"))
          }
        }
        /*      if (message is Message.LogEntries) {
              if (!message.entries.isEmpty()) {
                db.queries.transaction {
                  message.entries.forEach { entry ->
                    db.queries.insertOrReplace(entry)
                  }
                }
              } else log.warn { "received empty LogEntries" }
              sendSerialized<Message>(Message.OK)
              log.trace { "sent OK" }
            }

       */
      }
    }.exceptionOrNull().also {
      log.debug { "webSocketSession finished reason:${it?.message}" }
    }


    /*log.debug { "closing because we're done" }
    close(CloseReason(CloseReason.Codes.NORMAL, "Done"))*/
  }

