package org.danbrough.hb.commands

import com.github.ajalt.clikt.core.Context
import com.github.ajalt.clikt.parameters.options.defaultLazy
import com.github.ajalt.clikt.parameters.options.option
import kotlinx.io.files.Path
import org.danbrough.hb.HBContext
import org.danbrough.hb.log
import org.danbrough.krch.KrchContext
import org.danbrough.krch.config.parseConfigFile

fun HBContext.configCommand(name: String) = object : KrchContext.Command(name) {
  val file by option().defaultLazy {
    configFilePath.toString()
  }

  override fun help(context: Context): String =
    "Prints out the contents of the config file"

  override fun run() {
    log.debug { "parsing $file" }
    parseConfigFile(Path(file)).forEach {
      log.debug { "'${it.first}' -> '${it.second}'" }
    }
    log.debug { "config parse complete" }
  }
}


