package org.danbrough.hb.commands

import com.github.ajalt.clikt.parameters.options.flag
import com.github.ajalt.clikt.parameters.options.option
import com.github.ajalt.clikt.parameters.options.required
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.json.io.decodeSourceToSequence
import org.danbrough.hb.HBContext
import org.danbrough.hb.JsonLog
import org.danbrough.hb.LogType
import org.danbrough.hb.log
import org.danbrough.krch.KrchContext
import kotlin.uuid.Uuid


@OptIn(ExperimentalSerializationApi::class)
fun HBContext.importFromFile(path: String, deleteExisting: Boolean = false) {
  log.info { "loadFromFile(): $path" }

  hbDatabase.queries.transaction {
    if (deleteExisting) hbDatabase.queries.logDeleteAll()
    pathToSource(path).use { source ->
      json.decodeSourceToSequence<JsonLog>(source).forEach { log ->
        val id = Uuid.parse(log.id)
        id.toLongs { msb, lsb ->
          hbDatabase.insertLog2(
            msb,
            lsb,
            LogType.valueOf(log.subject.substringAfterLast('/').uppercase()),
            log.node?.ifBlank { rootCommand.nodeID } ?: "",
            log.count.toLong())
        }
      }
    }
  }
}

fun HBContext.importCommand(name: String) = object : KrchContext.Command(name) {
  val file: String by option().required()
  val deleteExisting: Boolean by option().flag(default = false)

  @OptIn(ExperimentalSerializationApi::class)
  override fun run() {
    importFromFile(file, deleteExisting)
  }
}

