package org.danbrough.hb.server

import kotlinx.serialization.Contextual
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import org.danbrough.hb.Log


@Serializable
sealed class Message {

  @Serializable
  @SerialName("ok")
  object OK : Message()

  @Serializable
  @SerialName("sync")
  object Sync : Message()

  @Serializable
  @SerialName("status")
  data class Status(val message: String) : Message()

  @Serializable
  @SerialName("entry")
  data class LogEntry(val log: @Contextual Log) : Message()

  @Serializable
  @SerialName("entries")
  data class LogEntries(val entries: List<@Contextual Log>) : Message()


}

