package org.danbrough.hb.server

import app.cash.sqldelight.coroutines.asFlow
import app.cash.sqldelight.coroutines.mapToList
import io.ktor.server.routing.Routing
import io.ktor.server.websocket.sendSerialized
import io.ktor.server.websocket.webSocket
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.currentCoroutineContext
import kotlinx.coroutines.flow.asFlow
import kotlinx.coroutines.flow.filter
import kotlinx.coroutines.flow.flatMapMerge
import org.danbrough.hb.HBContext
import org.danbrough.hb.log
import kotlin.time.Duration.Companion.seconds

@OptIn(ExperimentalCoroutinesApi::class)
fun Routing.watchDataHandler(context: HBContext, path: String) {
  webSocket(path) {

    val fromID = call.request.queryParameters["fromID"]?.toLong() ?: -1L
    val db = context.hbDatabase

    log.debug { "watchDataHandler session started on thread:${context.threadName()} fromID: $fromID" }

    var lastID: Long = fromID
    /*    db.latestLogID(5.seconds).collect { id ->
          log.debug { "logFlowID.collect: $lastID -> $id" }
          if (id > lastID) {
            val logFlow = db.queries.logEntriesById(lastID).asFlow()
              .mapToList(currentCoroutineContext()).flatMapMerge { it.chunked(100).asFlow() }
            logFlow.collect { logs ->
              log.debug { "sending ${logs.count()} logs from $lastID" }
              sendSerialized<Message>(Message.LogEntries(logs))
              lastID = logs.last().id
            }
            log.debug { "finished collecting on log flow" }
          }
        }*/

    db.latestLogID(5.seconds)
      .filter { id -> id > lastID }
      .flatMapMerge { id ->
        db.queries.logEntriesById(lastID).asFlow()
          .mapToList(currentCoroutineContext()).flatMapMerge { it.chunked(10).asFlow() }
      }.collect { logs ->
        log.debug { "sending ${logs.count()} logs from $lastID" }
        sendSerialized<Message>(Message.LogEntries(logs))
        lastID = logs.last().id
      }


    //log.debug { "closing.." }
    ////cancel("Decided to close")
    //close(CloseReason(CloseReason.Codes.NORMAL, "Felt like closing"))
  }
}
