/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.krch;

import com.github.ajalt.clikt.core.BaseCliktCommand;
import com.github.ajalt.clikt.core.BaseCliktCommandKt;
import com.github.ajalt.clikt.core.CoreCliktCommand;
import com.github.ajalt.clikt.core.CoreCliktCommandKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import klog.KlogKt;
import klog.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.io.files.FileSystemJvmKt;
import org.danbrough.krch.CommandMap;
import org.danbrough.krch.KrchContext;
import org.danbrough.krch.config.ConfigType;
import org.danbrough.krch.config.ParseConfigFileKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a)\u0010\u0004\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a\u0018\u0010\u0010\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003*\"\u0010\r\"\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0011"}, d2={"log", "Lklog/Logger;", "getLog", "()Lklog/Logger;", "main", "", "Lorg/danbrough/krch/KrchContext;", "cmdLineArgs", "", "", "commandMap", "Lorg/danbrough/krch/CommandMap;", "(Lorg/danbrough/krch/KrchContext;[Ljava/lang/String;Lorg/danbrough/krch/CommandMap;)V", "CommandConstructor", "Lkotlin/Function1;", "Lorg/danbrough/krch/KrchContext$Command;", "loadConfig", "krch"})
@SourceDebugExtension(value={"SMAP\nkrunch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 krunch.kt\norg/danbrough/krch/KrunchKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,144:1\n1924#2,3:145\n1342#3,2:148\n*S KotlinDebug\n*F\n+ 1 krunch.kt\norg/danbrough/krch/KrunchKt\n*L\n22#1:145,3\n101#1:148,2\n*E\n"})
public final class KrunchKt {
    @NotNull
    private static final Logger log = KlogKt.logger((String)"KRCH");

    @NotNull
    public static final Logger getLog() {
        return log;
    }

    /*
     * WARNING - void declaration
     */
    public static final void main(@NotNull KrchContext<?> $this$main, @NotNull String[] cmdLineArgs, @NotNull CommandMap commandMap) {
        Intrinsics.checkNotNullParameter($this$main, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cmdLineArgs, (String)"cmdLineArgs");
        Intrinsics.checkNotNullParameter((Object)commandMap, (String)"commandMap");
        Logger.info$default((Logger)log, null, () -> KrunchKt.main$lambda$0($this$main, cmdLineArgs), (int)1, null);
        CollectionsKt.addAll((Collection)$this$main.getArgs$krch(), (Object[])cmdLineArgs);
        KrunchKt.loadConfig($this$main, commandMap);
        Iterable $this$forEachIndexed$iv = $this$main.getArgs$krch();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            KrchContext.Command command;
            String alias;
            String cmdName;
            void name;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            if (StringsKt.startsWith$default((CharSequence)((CharSequence)name), (char)'-', (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)(cmdName = StringsKt.substringBefore$default((String)name, (char)':', null, (int)2, null)), (Object)(alias = StringsKt.substringAfter$default((String)name, (char)':', null, (int)2, null)))) continue;
            Logger.warn$default((Logger)log, null, () -> KrunchKt.main$lambda$1$0(cmdName, alias), (int)1, null);
            commandMap.alias(cmdName, alias);
            Intrinsics.checkNotNull((Object)((Object)commandMap.get(alias)));
            KrchContext.Command command2 = command;
            boolean bl2 = false;
            Logger.error$default((Logger)log, null, () -> KrunchKt.main$lambda$1$1$0(command2), (int)1, null);
            CoreCliktCommand[] coreCliktCommandArray = new CoreCliktCommand[]{command2};
            BaseCliktCommandKt.subcommands((BaseCliktCommand)((BaseCliktCommand)$this$main.getRootCommand()), (BaseCliktCommand[])((BaseCliktCommand[])coreCliktCommandArray));
            $this$main.getArgs$krch().set(index, alias);
        }
        Logger.trace$default((Logger)log, null, () -> KrunchKt.main$lambda$2($this$main), (int)1, null);
        Logger.trace$default((Logger)log, null, () -> KrunchKt.main$lambda$3($this$main), (int)1, null);
        List<KrchContext.Command> commands = commandMap.commands();
        Logger.info$default((Logger)log, null, () -> KrunchKt.main$lambda$4(commands), (int)1, null);
        BaseCliktCommandKt.subcommands((BaseCliktCommand)((BaseCliktCommand)$this$main.getRootCommand()), (Iterable)commands);
        Logger.info$default((Logger)log, null, KrunchKt::main$lambda$5, (int)1, null);
        CoreCliktCommandKt.main((CoreCliktCommand)((CoreCliktCommand)$this$main.getRootCommand()), $this$main.getArgs$krch());
        Logger.info$default((Logger)log, null, () -> KrunchKt.main$lambda$6($this$main), (int)1, null);
    }

    private static final void loadConfig(KrchContext<?> $this$loadConfig, CommandMap commandMap) {
        if (!FileSystemJvmKt.SystemFileSystem.exists($this$loadConfig.getConfigFilePath())) {
            Logger.debug$default((Logger)log, null, () -> KrunchKt.loadConfig$lambda$0($this$loadConfig), (int)1, null);
            return;
        }
        Logger.debug$default((Logger)log, null, () -> KrunchKt.loadConfig$lambda$1($this$loadConfig), (int)1, null);
        List extraArgs = new ArrayList();
        Object prefix = null;
        prefix = "";
        Sequence<Triple<ConfigType, String, String>> $this$forEach$iv = ParseConfigFileKt.parseConfigFile($this$loadConfig.getConfigFilePath());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple triple = (Triple)element$iv;
            boolean bl = false;
            ConfigType type = (ConfigType)((Object)triple.component1());
            String key = (String)triple.component2();
            String value = (String)triple.component3();
            Logger.debug$default((Logger)log, null, () -> KrunchKt.loadConfig$lambda$2$0(type, key, value), (int)1, null);
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Map<String, String> map = $this$loadConfig.getValueMap$krch();
                    String string = prefix + key;
                    String string2 = value;
                    Intrinsics.checkNotNull((Object)string2);
                    map.put(string, string2);
                    break;
                }
                case 2: {
                    String alias = StringsKt.substringAfter$default((String)key, (char)':', null, (int)2, null);
                    String cmdName = StringsKt.substringBefore$default((String)key, (char)':', null, (int)2, null);
                    if (Intrinsics.areEqual((Object)cmdName, (Object)"global")) {
                        prefix = "";
                        break;
                    }
                    prefix = alias + ".";
                    Logger.trace$default((Logger)log, null, () -> KrunchKt.loadConfig$lambda$2$1(cmdName, alias), (int)1, null);
                    ((Collection)extraArgs).add(alias);
                    commandMap.alias(cmdName, alias);
                    break;
                }
                case 3: {
                    String flagValue = prefix + StringsKt.removePrefix((String)key, (CharSequence)"--");
                    Logger.trace$default((Logger)log, null, () -> KrunchKt.loadConfig$lambda$2$2(flagValue), (int)1, null);
                    $this$loadConfig.getValueMap$krch().put(flagValue, "1");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Logger.trace$default((Logger)log, null, () -> KrunchKt.loadConfig$lambda$3($this$loadConfig, extraArgs), (int)1, null);
        $this$loadConfig.getArgs$krch().addAll(0, extraArgs);
    }

    private static final Object main$lambda$1$1$0(KrchContext.Command $command) {
        return "adding command: " + $command;
    }

    private static final Object main$lambda$1$0(String $cmdName, String $alias) {
        return "commandMap.alias(" + $cmdName + ", " + $alias + ")";
    }

    private static final CharSequence main$lambda$3$0(CoreCliktCommand it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCommandName();
    }

    private static final CharSequence main$lambda$4$0(KrchContext.Command it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getCommandName();
    }

    private static final Object main$lambda$0(KrchContext $this_main, String[] $cmdLineArgs) {
        return $this_main + "::main() cmdLineArgs: [" + ArraysKt.joinToString$default((Object[])$cmdLineArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "]";
    }

    private static final Object main$lambda$2(KrchContext $this_main) {
        return "modified args: " + $this_main.getArgs$krch();
    }

    private static final Object main$lambda$3(KrchContext $this_main) {
        return "registered commands: " + CollectionsKt.joinToString$default((Iterable)((CoreCliktCommand)$this_main.getRootCommand()).registeredSubcommands(), (CharSequence)",", null, null, (int)0, null, KrunchKt::main$lambda$3$0, (int)30, null);
    }

    private static final Object main$lambda$4(List $commands) {
        return "commandMap commands: " + CollectionsKt.joinToString$default((Iterable)$commands, (CharSequence)",", null, null, (int)0, null, KrunchKt::main$lambda$4$0, (int)30, null);
    }

    private static final Object main$lambda$5() {
        return "calling: rootCommand.main(args) ..";
    }

    private static final Object main$lambda$6(KrchContext $this_main) {
        return Reflection.getOrCreateKotlinClass($this_main.getClass()) + ".main(args) finished.";
    }

    private static final Object loadConfig$lambda$2$0(ConfigType $type, String $key, String $value) {
        return "config: " + $type + ": " + (StringsKt.contains$default((CharSequence)$key, (CharSequence)"password", (boolean)false, (int)2, null) ? $key + "=*****" : $key + "=" + $value);
    }

    private static final Object loadConfig$lambda$2$1(String $cmdName, String $alias) {
        return "adding alias: " + $cmdName + " -> " + $alias + " to extra args";
    }

    private static final Object loadConfig$lambda$2$2(String $flagValue) {
        return "setting flag: " + $flagValue;
    }

    private static final Object loadConfig$lambda$0(KrchContext $this_loadConfig) {
        return "configPath " + $this_loadConfig.getConfigFilePath() + " not found";
    }

    private static final Object loadConfig$lambda$1(KrchContext $this_loadConfig) {
        return "loadConfig(): configPath:'" + $this_loadConfig.getConfigFilePath() + "'";
    }

    private static final Object loadConfig$lambda$3(KrchContext $this_loadConfig, List $extraArgs) {
        return "args: [" + CollectionsKt.joinToString$default((Iterable)$this_loadConfig.getArgs$krch(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "] extra args: [" + CollectionsKt.joinToString$default((Iterable)$extraArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "]";
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigType.values().length];
            try {
                nArray[ConfigType.PROPERTY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.COMMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigType.FLAG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

