package org.danbrough.krch

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlin.coroutines.CoroutineContext

abstract class KrchContextJVMAndroid<R : KrchContext.Command>(scope: CoroutineScope) :
  KrchContext<R>(scope) {

  override fun getEnv(name: String): String? = System.getenv(name)

  override fun threadName(): String = Thread.currentThread().name

  override val coroutineContextIO: CoroutineContext = Dispatchers.IO
  override val coroutineContextMain: CoroutineContext = Dispatchers.Main
}