package org.danbrough.krch

import kotlinx.cinterop.toKString
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.IO
import platform.posix.getenv
import kotlin.coroutines.CoroutineContext

class KrchContextNative<R : KrchContext.Command>(scope: CoroutineScope) : KrchContext<R>(scope) {
  override fun getEnv(name: String): String? = getenv(name)?.toKString()
  override fun threadName(): String = platform.posix.pthread_self().toString()
  override val coroutineContextIO: CoroutineContext = Dispatchers.IO
  override val coroutineContextMain: CoroutineContext = Dispatchers.Main
  override val coroutineContextDefault: CoroutineContext = Dispatchers.Default
}