package app.softwork.sqldelight.postgresdialect

import app.softwork.sqldelight.postgresdialect.psi.PostgreSqlNativeTypes
import com.alecstrong.sql.psi.core.SqlParserUtil
import com.intellij.lang.ASTNode
import com.intellij.lang.PsiBuilder
import com.intellij.lang.parser.GeneratedParserUtilBase
import com.intellij.psi.PsiElement
import java.lang.AssertionError
import kotlin.Boolean
import kotlin.Int
import kotlin.jvm.JvmStatic

public object PostgreSqlNativeParserUtil : GeneratedParserUtilBase() {
  public var createElement: (ASTNode) -> PsiElement = {
      PostgreSqlNativeTypes.Factory.createElement(it) }

  public var overrides: GeneratedParserUtilBase.Parser? = null

  public var bind_parameter: GeneratedParserUtilBase.Parser? = null

  @JvmStatic
  public fun overridesExt(
    builder: PsiBuilder,
    level: Int,
    overrides: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.overrides ?: overrides).parse(builder, level)

  @JvmStatic
  public fun bindParameterExt(
    builder: PsiBuilder,
    level: Int,
    bind_parameter: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.bind_parameter ?: bind_parameter).parse(builder, level)

  public fun reset() {
    createElement = { PostgreSqlNativeTypes.Factory.createElement(it) }
    overrides = null
    bind_parameter = null
  }

  public fun overrideSqlParser() {
    SqlParserUtil.bind_parameter = Parser { psiBuilder, i -> bind_parameter?.parse(psiBuilder, i) ?:
        PostgreSqlNativeParser.bind_parameter_real(psiBuilder, i) }
    val currentCreateElement = SqlParserUtil.createElement
    SqlParserUtil.createElement = {
      try {
        createElement(it)
      } catch(e: AssertionError) {
        currentCreateElement(it)
      }
    }
  }
}
