/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.xtras;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.danbrough.xtras.Logger;
import org.danbrough.xtras.XtrasLoggerKt;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B+\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/danbrough/xtras/XtrasLoggerImpl;", "Lorg/danbrough/xtras/Logger;", "project", "Lorg/gradle/api/Project;", "tag", "", "logToStdout", "", "logToGradle", "<init>", "(Lorg/gradle/api/Project;Ljava/lang/String;ZZ)V", "getProject", "()Lorg/gradle/api/Project;", "getTag", "()Ljava/lang/String;", "getLogToStdout", "()Z", "getLogToGradle", "log", "", "msg", "level", "Lorg/gradle/api/logging/LogLevel;", "err", "", "plugin"})
public final class XtrasLoggerImpl
extends Logger {
    @Nullable
    private final Project project;
    @NotNull
    private final String tag;
    private final boolean logToStdout;
    private final boolean logToGradle;

    @Inject
    public XtrasLoggerImpl(@Nullable Project project, @NotNull String tag, boolean logToStdout, boolean logToGradle) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.project = project;
        this.tag = tag;
        this.logToStdout = logToStdout;
        this.logToGradle = logToGradle;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    public final boolean getLogToStdout() {
        return this.logToStdout;
    }

    public final boolean getLogToGradle() {
        return this.logToGradle;
    }

    @Override
    public void log(@NotNull String msg, @NotNull LogLevel level, @Nullable Throwable err) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.logToStdout) {
            String string = this.getTag().length() == 4 ? " " : "";
            String string2 = XtrasLoggerKt.colored(this.getTag(), level);
            String string3 = XtrasLoggerKt.colored(msg, level);
            Object object = err;
            if (object == null || (object = ((Throwable)object).getMessage()) == null || (object = XtrasLoggerKt.colored((String)object, level)) == null) {
                object = "";
            }
            String string4 = string + string2 + ": " + string3 + " " + (String)object;
            System.out.println((Object)string4);
        }
        if (this.logToGradle) {
            Project project = this.project;
            Intrinsics.checkNotNull((Object)project);
            project.getLogger().log(level, msg);
        }
    }
}

