/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.xtras.git;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.danbrough.xtras.TaskNamesKt;
import org.danbrough.xtras.XtrasLibrary;
import org.danbrough.xtras.XtrasLoggerKt;
import org.danbrough.xtras.Xtras_propertiesKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.process.ExecOutput;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0003"}, d2={"registerGitSourceDownloadTask", "", "Lorg/danbrough/xtras/XtrasLibrary;", "plugin"})
public final class TaskDownloadSourceKt {
    @NotNull
    public static final String registerGitSourceDownloadTask(@NotNull XtrasLibrary $this$registerGitSourceDownloadTask) {
        Intrinsics.checkNotNullParameter((Object)$this$registerGitSourceDownloadTask, (String)"<this>");
        String taskName = TaskNamesKt.taskNameSourceDownload($this$registerGitSourceDownloadTask);
        Project $this$registerGitSourceDownloadTask_u24lambda_u240 = $this$registerGitSourceDownloadTask.getProject();
        boolean bl = false;
        $this$registerGitSourceDownloadTask_u24lambda_u240.getTasks().register(taskName, new Action($this$registerGitSourceDownloadTask_u24lambda_u240, $this$registerGitSourceDownloadTask){
            final /* synthetic */ Project $this_run;
            final /* synthetic */ XtrasLibrary $this_registerGitSourceDownloadTask;
            {
                this.$this_run = $receiver;
                this.$this_registerGitSourceDownloadTask = $receiver2;
            }

            public final void execute(Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                $this$register.setDescription("Download required commits from remote repository to " + Xtras_propertiesKt.getXtrasCacheDir(this.$this_run));
                XtrasLibrary.SourceConfig sourceConfig = this.$this_registerGitSourceDownloadTask.getSourceConfig();
                Intrinsics.checkNotNull((Object)sourceConfig, (String)"null cannot be cast to non-null type org.danbrough.xtras.XtrasLibrary.GitSourceConfig");
                XtrasLibrary.GitSourceConfig gitConfig = (XtrasLibrary.GitSourceConfig)sourceConfig;
                File repoDir = this.$this_registerGitSourceDownloadTask.getCacheDir();
                File fetchFile = FilesKt.resolve((File)repoDir, (String)"FETCH_HEAD");
                $this$register.getInputs().property("url", gitConfig.getUrl());
                $this$register.getInputs().property("commit", gitConfig.getCommit());
                $this$register.getOutputs().file((Object)fetchFile);
                $this$register.doFirst(new Action(this.$this_run, gitConfig, repoDir){
                    final /* synthetic */ Project $this_run;
                    final /* synthetic */ XtrasLibrary.GitSourceConfig $gitConfig;
                    final /* synthetic */ File $repoDir;
                    {
                        this.$this_run = $receiver;
                        this.$gitConfig = $gitConfig;
                        this.$repoDir = $repoDir;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(Task $this$doFirst) {
                        void $this$xDebug_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                        Project project = this.$this_run;
                        String msg$iv = "running " + $this$doFirst.getName() + " with " + this.$gitConfig.getUrl().get() + " commit: " + this.$gitConfig.getCommit().get() + " gitDir: " + this.$repoDir;
                        Throwable err$iv = null;
                        boolean $i$f$xDebug = false;
                        XtrasLoggerKt.getXtrasLogger((Project)$this$xDebug_u24default$iv).log(msg$iv, LogLevel.INFO, err$iv);
                    }
                });
                $this$register.getActions().add(new Action(repoDir, this.$this_run, gitConfig){
                    final /* synthetic */ File $repoDir;
                    final /* synthetic */ Project $this_run;
                    final /* synthetic */ XtrasLibrary.GitSourceConfig $gitConfig;
                    {
                        this.$repoDir = $repoDir;
                        this.$this_run = $receiver;
                        this.$gitConfig = $gitConfig;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        if (!FilesKt.resolve((File)this.$repoDir, (String)"HEAD").exists()) {
                            Project $this$xDebug_u24default$iv;
                            String msg$iv;
                            Project $this$xError_u24default$iv;
                            boolean $i$f$xError;
                            Throwable err$iv;
                            void $this$xDebug_u24default$iv2;
                            Project project = this.$this_run;
                            String msg$iv2 = "initializing bare repository at " + this.$repoDir + " ..";
                            Throwable err$iv2 = null;
                            boolean $i$f$xDebug = false;
                            XtrasLoggerKt.getXtrasLogger((Project)$this$xDebug_u24default$iv2).log(msg$iv2, LogLevel.INFO, err$iv2);
                            project = this.$this_run.getProviders().exec(new Action(this.$repoDir){
                                final /* synthetic */ File $repoDir;
                                {
                                    this.$repoDir = $repoDir;
                                }

                                public final void execute(ExecSpec $this$exec) {
                                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                    Object[] objectArray = new Object[]{"git", "init", "--bare", this.$repoDir.getAbsolutePath()};
                                    $this$exec.commandLine(objectArray);
                                }
                            });
                            Project project2 = this.$this_run;
                            Project it = project;
                            boolean bl = false;
                            if (((ExecResult)it.getResult().get()).getExitValue() != 0) {
                                Project project3 = project2;
                                Object object = it.getStandardError().getAsText().get();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                                String string = ((Object)StringsKt.trim((CharSequence)((String)object))).toString();
                                err$iv = null;
                                $i$f$xError = false;
                                XtrasLoggerKt.getXtrasLogger($this$xError_u24default$iv).log(msg$iv, LogLevel.ERROR, err$iv);
                            }
                            $this$xError_u24default$iv = project2;
                            Object object = it.getStandardOutput().getAsText().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                            msg$iv = ((Object)StringsKt.trim((CharSequence)((String)object))).toString();
                            err$iv = null;
                            boolean $i$f$xDebug2 = false;
                            XtrasLoggerKt.getXtrasLogger($this$xDebug_u24default$iv).log(msg$iv, LogLevel.INFO, err$iv);
                            project = this.$this_run.getProviders().exec(new Action(this.$repoDir, this.$gitConfig){
                                final /* synthetic */ File $repoDir;
                                final /* synthetic */ XtrasLibrary.GitSourceConfig $gitConfig;
                                {
                                    this.$repoDir = $repoDir;
                                    this.$gitConfig = $gitConfig;
                                }

                                public final void execute(ExecSpec $this$exec) {
                                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                    $this$exec.workingDir((Object)this.$repoDir);
                                    Object[] objectArray = new Object[]{"git", "remote", "add", "origin", this.$gitConfig.getUrl().get()};
                                    $this$exec.commandLine(objectArray);
                                }
                            });
                            project2 = this.$this_run;
                            it = project;
                            boolean bl2 = false;
                            if (((ExecResult)it.getResult().get()).getExitValue() != 0) {
                                $this$xDebug_u24default$iv = project2;
                                Object object2 = it.getStandardError().getAsText().get();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                                msg$iv = ((Object)StringsKt.trim((CharSequence)((String)object2))).toString();
                                err$iv = null;
                                $i$f$xError = false;
                                XtrasLoggerKt.getXtrasLogger($this$xError_u24default$iv).log(msg$iv, LogLevel.ERROR, err$iv);
                            }
                            $this$xError_u24default$iv = project2;
                            Object object3 = it.getStandardOutput().getAsText().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                            msg$iv = ((Object)StringsKt.trim((CharSequence)((String)object3))).toString();
                            err$iv = null;
                            $i$f$xDebug2 = false;
                            XtrasLoggerKt.getXtrasLogger($this$xDebug_u24default$iv).log(msg$iv, LogLevel.INFO, err$iv);
                        }
                    }
                });
                $this$register.getActions().add(new Action(gitConfig, this.$this_run, repoDir){
                    final /* synthetic */ XtrasLibrary.GitSourceConfig $gitConfig;
                    final /* synthetic */ Project $this_run;
                    final /* synthetic */ File $repoDir;
                    {
                        this.$gitConfig = $gitConfig;
                        this.$this_run = $receiver;
                        this.$repoDir = $repoDir;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(Task $this$add) {
                        void $this$xDebug_u24default$iv;
                        String msg$iv;
                        Project $this$xError_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        ExecOutput execOutput = new String[6];
                        execOutput[0] = "git";
                        execOutput[1] = "fetch";
                        execOutput[2] = "origin";
                        execOutput[3] = "--depth";
                        execOutput[4] = "1";
                        Intrinsics.checkNotNullExpressionValue((Object)this.$gitConfig.getCommit().get(), (String)"get(...)");
                        List cmdLine = CollectionsKt.listOf((Object[])execOutput);
                        XtrasLoggerKt.xTrace$default(this.$this_run, "running " + CollectionsKt.joinToString$default((Iterable)cmdLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 2, null);
                        execOutput = this.$this_run.getProviders().exec(new Action(this.$repoDir, cmdLine){
                            final /* synthetic */ File $repoDir;
                            final /* synthetic */ List<String> $cmdLine;
                            {
                                this.$repoDir = $repoDir;
                                this.$cmdLine = $cmdLine;
                            }

                            public final void execute(ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.workingDir((Object)this.$repoDir);
                                Collection $this$toTypedArray$iv = this.$cmdLine;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                                $this$exec.commandLine((Object[])Arrays.copyOf(stringArray, stringArray.length));
                            }
                        });
                        Project project = this.$this_run;
                        ExecOutput it = execOutput;
                        boolean bl = false;
                        Project project2 = project;
                        Object object = it.getStandardError().getAsText().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        String string = ((Object)StringsKt.trim((CharSequence)((String)object))).toString();
                        Throwable err$iv = null;
                        boolean $i$f$xError = false;
                        XtrasLoggerKt.getXtrasLogger($this$xError_u24default$iv).log(msg$iv, LogLevel.ERROR, err$iv);
                        $this$xError_u24default$iv = project;
                        Object object2 = it.getStandardOutput().getAsText().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                        msg$iv = ((Object)StringsKt.trim((CharSequence)((String)object2))).toString();
                        err$iv = null;
                        boolean $i$f$xDebug = false;
                        XtrasLoggerKt.getXtrasLogger((Project)$this$xDebug_u24default$iv).log(msg$iv, LogLevel.INFO, err$iv);
                    }
                });
                $this$register.getActions().add(new Action(fetchFile, this.$this_run, repoDir){
                    final /* synthetic */ File $fetchFile;
                    final /* synthetic */ Project $this_run;
                    final /* synthetic */ File $repoDir;
                    {
                        this.$fetchFile = $fetchFile;
                        this.$this_run = $receiver;
                        this.$repoDir = $repoDir;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(Task $this$add) {
                        void $this$xDebug_u24default$iv;
                        String msg$iv;
                        CharSequence $this$xError_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        ExecOutput execOutput = new String[4];
                        execOutput[0] = "git";
                        execOutput[1] = "reset";
                        execOutput[2] = "--soft";
                        CharSequence charSequence = (CharSequence)CollectionsKt.first((List)FilesKt.readLines$default((File)this.$fetchFile, null, (int)1, null));
                        Regex regex = new Regex("\\s+");
                        int n = 0;
                        execOutput[3] = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)regex.split(charSequence, n))))).toString();
                        List cmdLine = CollectionsKt.listOf((Object[])execOutput);
                        XtrasLoggerKt.xTrace$default(this.$this_run, "running " + CollectionsKt.joinToString$default((Iterable)cmdLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 2, null);
                        execOutput = this.$this_run.getProviders().exec(new Action(this.$repoDir, cmdLine){
                            final /* synthetic */ File $repoDir;
                            final /* synthetic */ List<String> $cmdLine;
                            {
                                this.$repoDir = $repoDir;
                                this.$cmdLine = $cmdLine;
                            }

                            public final void execute(ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.workingDir((Object)this.$repoDir);
                                Collection $this$toTypedArray$iv = this.$cmdLine;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                                $this$exec.commandLine((Object[])Arrays.copyOf(stringArray, stringArray.length));
                            }
                        });
                        charSequence = this.$this_run;
                        ExecOutput it = execOutput;
                        boolean bl = false;
                        CharSequence charSequence2 = charSequence;
                        Object object = it.getStandardError().getAsText().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        String string = ((Object)StringsKt.trim((CharSequence)((String)object))).toString();
                        Throwable err$iv = null;
                        boolean $i$f$xError = false;
                        XtrasLoggerKt.getXtrasLogger((Project)$this$xError_u24default$iv).log(msg$iv, LogLevel.ERROR, err$iv);
                        $this$xError_u24default$iv = charSequence;
                        Object object2 = it.getStandardOutput().getAsText().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                        msg$iv = ((Object)StringsKt.trim((CharSequence)((String)object2))).toString();
                        err$iv = null;
                        boolean $i$f$xDebug = false;
                        XtrasLoggerKt.getXtrasLogger((Project)$this$xDebug_u24default$iv).log(msg$iv, LogLevel.INFO, err$iv);
                    }
                });
            }
        });
        return taskName;
    }
}

