/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.xtras.git;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.danbrough.xtras.TaskNamesKt;
import org.danbrough.xtras.XtrasLibrary;
import org.danbrough.xtras.XtrasLoggerKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.specs.Spec;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"registerGitSourceExtractTask", "", "Lorg/danbrough/xtras/XtrasLibrary;", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "plugin"})
public final class TaskExtractSourceKt {
    @NotNull
    public static final String registerGitSourceExtractTask(@NotNull XtrasLibrary $this$registerGitSourceExtractTask, @NotNull KonanTarget target) {
        Intrinsics.checkNotNullParameter((Object)$this$registerGitSourceExtractTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String taskName = TaskNamesKt.taskNameSourceExtract($this$registerGitSourceExtractTask, target);
        Project $this$registerGitSourceExtractTask_u24lambda_u240 = $this$registerGitSourceExtractTask.getProject();
        boolean bl = false;
        $this$registerGitSourceExtractTask_u24lambda_u240.getTasks().register(taskName, new Action($this$registerGitSourceExtractTask, target, $this$registerGitSourceExtractTask_u24lambda_u240){
            final /* synthetic */ XtrasLibrary $this_registerGitSourceExtractTask;
            final /* synthetic */ KonanTarget $target;
            final /* synthetic */ Project $this_run;
            {
                this.$this_registerGitSourceExtractTask = $receiver;
                this.$target = $target;
                this.$this_run = $receiver2;
            }

            public final void execute(Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                File sourcesDir = (File)this.$this_registerGitSourceExtractTask.getSourcesDirMap().invoke((Object)this.$target);
                File outputFile = FilesKt.resolve((File)sourcesDir, (String)".xtras_extracted");
                $this$register.getOutputs().file((Object)outputFile);
                Object[] objectArray = new Object[]{TaskNamesKt.taskNameSourceDownload(this.$this_registerGitSourceExtractTask)};
                $this$register.dependsOn(objectArray);
                $this$register.setDescription("Download required commits from remote repository to " + sourcesDir);
                this.$this_registerGitSourceExtractTask.getPackageFileMap().invoke((Object)this.$target);
                $this$register.onlyIf(new Spec(outputFile){
                    final /* synthetic */ File $outputFile;
                    {
                        this.$outputFile = $outputFile;
                    }

                    public final boolean isSatisfiedBy(Task it) {
                        return !this.$outputFile.exists();
                    }
                });
                $this$register.getActions().add(new Action(sourcesDir, this.$this_run, this.$this_registerGitSourceExtractTask, outputFile){
                    final /* synthetic */ File $sourcesDir;
                    final /* synthetic */ Project $this_run;
                    final /* synthetic */ XtrasLibrary $this_registerGitSourceExtractTask;
                    final /* synthetic */ File $outputFile;
                    {
                        this.$sourcesDir = $sourcesDir;
                        this.$this_run = $receiver;
                        this.$this_registerGitSourceExtractTask = $receiver2;
                        this.$outputFile = $outputFile;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(Task $this$add) {
                        String msg$iv;
                        Project $this$xDebug_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        if (this.$sourcesDir.exists()) {
                            void $this$xWarn_u24default$iv;
                            Project project = this.$this_run;
                            String msg$iv2 = "deleting existing " + this.$sourcesDir;
                            Throwable err$iv = null;
                            boolean $i$f$xWarn = false;
                            XtrasLoggerKt.getXtrasLogger((Project)$this$xWarn_u24default$iv).log(msg$iv2, LogLevel.QUIET, err$iv);
                            FilesKt.deleteRecursively((File)this.$sourcesDir);
                        }
                        Object[] objectArray = new Object[]{"git", "clone", this.$this_registerGitSourceExtractTask.getCacheDir(), this.$sourcesDir};
                        List cmdLine = CollectionsKt.listOf((Object[])objectArray);
                        XtrasLoggerKt.xTrace$default(this.$this_run, "running " + CollectionsKt.joinToString$default((Iterable)cmdLine, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 2, null);
                        objectArray = this.$this_run.getProviders().exec(new Action(cmdLine){
                            final /* synthetic */ List<Object> $cmdLine;
                            {
                                this.$cmdLine = $cmdLine;
                            }

                            public final void execute(ExecSpec $this$exec) {
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                Collection $this$toTypedArray$iv = this.$cmdLine;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                                $this$exec.commandLine(Arrays.copyOf(objectArray, objectArray.length));
                            }
                        });
                        Project project = this.$this_run;
                        File file = this.$outputFile;
                        Object[] it = objectArray;
                        boolean bl = false;
                        Project project2 = project;
                        Object object = it.getStandardOutput().getAsText().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        String string = "STDOUT: " + ((Object)StringsKt.trim((CharSequence)((String)object))).toString();
                        Throwable err$iv = null;
                        boolean $i$f$xDebug = false;
                        XtrasLoggerKt.getXtrasLogger($this$xDebug_u24default$iv).log(msg$iv, LogLevel.INFO, err$iv);
                        $this$xDebug_u24default$iv = project;
                        Object object2 = it.getStandardError().getAsText().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                        msg$iv = "STDERR: " + ((Object)StringsKt.trim((CharSequence)((String)object2))).toString();
                        err$iv = null;
                        $i$f$xDebug = false;
                        XtrasLoggerKt.getXtrasLogger($this$xDebug_u24default$iv).log(msg$iv, LogLevel.INFO, err$iv);
                        if (((ExecResult)it.getResult().get()).getExitValue() == 0) {
                            file.createNewFile();
                        }
                    }
                });
            }
        });
        return taskName;
    }
}

