/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.xtras;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.danbrough.xtras.Logger;
import org.danbrough.xtras.XtrasLoggerKt;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/danbrough/xtras/XtrasLoggerImpl;", "Lorg/danbrough/xtras/Logger;", "tag", "", "<init>", "(Ljava/lang/String;)V", "getTag", "()Ljava/lang/String;", "log", "", "msg", "level", "Lorg/gradle/api/logging/LogLevel;", "err", "", "plugin"})
public final class XtrasLoggerImpl
extends Logger {
    @NotNull
    private final String tag;

    @Inject
    public XtrasLoggerImpl(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tag = tag;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public void log(@NotNull String msg, @NotNull LogLevel level, @Nullable Throwable err) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        String string = this.getTag().length() == 4 ? " " : "";
        String string2 = XtrasLoggerKt.colored(this.getTag(), level);
        String string3 = XtrasLoggerKt.colored(msg, level);
        Object object = err;
        if (object == null || (object = ((Throwable)object).getMessage()) == null || (object = XtrasLoggerKt.colored((String)object, level)) == null) {
            object = "";
        }
        String string4 = string + string2 + ": " + string3 + " " + (String)object;
        System.out.println((Object)string4);
    }
}

